/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.core.scheduler;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.Objects;
import net.impactdev.impactor.api.scheduler.Ticks;
import org.jetbrains.annotations.NotNull;

public class ImpactorTicks
implements Ticks {
    private static final int TICK_DURATION_MS = 50;
    private static final Duration EFFECTIVE_MINIMUM_DURATION = Duration.ofMillis(50L);
    private static final int MINECRAFT_DAY_TICKS = 24000;
    private static final int MINECRAFT_HOUR_TICKS = 1000;
    private static final double MINECRAFT_MINUTE_TICKS = 16.666666666666668;
    private static final double MINECRAFT_SECOND_TICKS = 0.2777777777777778;
    private static final int MINECRAFT_EPOCH_OFFSET = 6000;
    private final long ticks;
    private final Duration effectiveMinimumDuration;

    public ImpactorTicks(long ticks) {
        this.ticks = ticks;
        this.effectiveMinimumDuration = EFFECTIVE_MINIMUM_DURATION.multipliedBy(this.ticks);
    }

    @Override
    public Duration expectedDuration() {
        return this.effectiveMinimumDuration;
    }

    @Override
    public long ticks() {
        return this.ticks;
    }

    @Override
    public long minecraftSeconds() {
        return 3600L * this.ticks / 1000L + (long)((double)(this.ticks % 1000L) / 0.2777777777777778);
    }

    @Override
    public Duration minecraftDayTimeDuration() {
        return Duration.of(this.minecraftSeconds(), ChronoUnit.SECONDS);
    }

    public static final class Factory
    implements Ticks.Factory {
        private final Ticks zero = new ImpactorTicks(0L);
        private final Ticks single = new ImpactorTicks(1L);
        private final Ticks minecraftHour = new ImpactorTicks(1000L);
        private final Ticks minecraftDay = new ImpactorTicks(24000L);

        @Override
        @NotNull
        public Ticks of(long ticks) {
            if (ticks < 0L) {
                throw new IllegalArgumentException("Tick must be greater than 0!");
            }
            return new ImpactorTicks(ticks);
        }

        @Override
        @NotNull
        public Ticks ofWallClockTime(long time, @NotNull TemporalUnit temporalUnit) {
            if (time < 0L) {
                throw new IllegalArgumentException("Time must be greater than 0!");
            }
            Objects.requireNonNull(temporalUnit);
            long target = temporalUnit.getDuration().multipliedBy(time).toMillis();
            return this.of((long)Math.ceil((double)target / 50.0));
        }

        @Override
        @NotNull
        public Ticks ofMinecraftSeconds(long seconds) {
            if (seconds < 0L) {
                throw new IllegalArgumentException("Seconds must be greater than 0!");
            }
            return this.of((long)Math.ceil((double)seconds * 0.2777777777777778));
        }

        @Override
        @NotNull
        public Ticks ofMinecraftHours(long hours) {
            if (hours < 0L) {
                throw new IllegalArgumentException("Hours must be greater than 0!");
            }
            return this.of(hours * 1000L);
        }

        @Override
        public Ticks zero() {
            return this.zero;
        }

        @Override
        public Ticks single() {
            return this.single;
        }

        @Override
        public Ticks minecraftHour() {
            return this.minecraftHour;
        }

        @Override
        public Ticks minecraftDay() {
            return this.minecraftDay;
        }
    }
}

